/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.reload;

import com.google.common.base.Preconditions;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IReloader;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.animation.ReloadAnimation;
import dev.toma.gunsrpg.client.animation.StagedReloadAnimation;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import java.util.ArrayList;
import java.util.List;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class StagedReloader
implements IReloader {
    private final StageDefinitionContainer container;
    private GunItem reloadingGun;
    private ItemStack stack;

    protected StagedReloader(StageDefinitionContainer container) {
        this.container = container;
        this.container.setStageFinishCallback(this::stageFinished);
    }

    public static StageDefinitionContainerBuilder builder() {
        return new StageDefinitionContainerBuilder();
    }

    @Override
    public void initiateReload(PlayerEntity player, GunItem item, ItemStack stack) {
        this.reloadingGun = item;
        this.stack = stack;
        this.container.init(item.getReloadTime(PlayerData.getUnsafe(player).getAttributes(), stack));
        if (player.field_70170_p.field_72995_K) {
            this.container.clientInit(item.getReloadAnimation(player));
        }
    }

    @Override
    public boolean isReloading() {
        return !this.container.hasFinished();
    }

    @Override
    public void enqueueCancel() {
        this.container.onUserCancel();
    }

    @Override
    public void forceCancel() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::cancelAnimations);
    }

    @Override
    public void tick(PlayerEntity player) {
        this.container.tick(player);
    }

    private void loadBullet(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof GunItem)) {
            return;
        }
        int max = this.reloadingGun.getMaxAmmo(PlayerData.getUnsafe(player).getAttributes());
        AmmoType type = this.reloadingGun.getAmmoType();
        IAmmoMaterial material = this.reloadingGun.getMaterialFromNBT(stack);
        if (player.func_184812_l_()) {
            this.reloadingGun.setAmmoCount(stack, Math.min(this.reloadingGun.getAmmo(stack) + 1, max));
        } else {
            ItemLocator.consume((IInventory)player.field_71071_by, ItemLocator.filterByAmmoTypeAndMaterial(type, material), ctx -> {
                ItemStack ammo = ctx.getCurrectStack();
                if (!ammo.func_190926_b()) {
                    ammo.func_190918_g(1);
                    this.reloadingGun.setAmmoCount(stack, Math.min(this.reloadingGun.getAmmo(stack) + 1, max));
                }
            });
        }
    }

    private void stageFinished(PlayerEntity player, IReloadingStage stage, boolean wasLast) {
        ReloadingStageType type = stage.stageType();
        if (type == ReloadingStageType.LOADING) {
            this.loadBullet(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelAnimations() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.remove(ModAnimations.RELOAD);
        pipeline.remove(ModAnimations.RELOAD_BULLET);
    }

    public static class StageDefinitionContainerBuilder {
        private int prepTicks;
        private final List<IReloadingStage> reloadingStages = new ArrayList<IReloadingStage>();

        private StageDefinitionContainerBuilder() {
        }

        public StageDefinitionContainerBuilder prepTicks(int prepTicks) {
            this.prepTicks = prepTicks;
            return this;
        }

        public StageDefinitionContainerBuilder stage(IReloadingStage stage) {
            this.reloadingStages.add(stage);
            return this;
        }

        public StagedReloader build() {
            Preconditions.checkState((this.prepTicks > 5 ? 1 : 0) != 0, (Object)"Preparation stage must be atleast 6 ticks long");
            Preconditions.checkState((this.reloadingStages.size() > 2 ? 1 : 0) != 0, (Object)"You must define atleast 3 stages");
            return new StagedReloader(new StageDefinitionContainer(this));
        }
    }

    public static class StageDefinitionContainer {
        private final int preparationStageLength;
        private final IReloadingStage[] definitions;
        private IStageFinishCallback stageFinishCallback;
        private int actualStage;
        private boolean finished;
        private boolean awaitingCancelation;

        private StageDefinitionContainer(StageDefinitionContainerBuilder builder) {
            this.preparationStageLength = (int)Math.ceil((double)builder.prepTicks / 2.0);
            this.definitions = builder.reloadingStages.toArray(new IReloadingStage[0]);
        }

        public void onUserCancel() {
            this.awaitingCancelation = true;
        }

        public void setStageFinishCallback(IStageFinishCallback callback) {
            this.stageFinishCallback = callback;
        }

        public void clientInit(ResourceLocation reloadAnimation) {
            this.definitions[0].initClient(reloadAnimation, this);
            this.definitions[this.definitions.length - 1].initClient(reloadAnimation, this);
        }

        public void init(int reloadTime) {
            for (int i = 1; i < this.definitions.length - 1; ++i) {
                this.definitions[i].setRemainingTicks(reloadTime);
            }
            this.definitions[this.definitions.length - 1].setRemainingTicks(this.preparationStageLength);
            IReloadingStage first = this.definitions[0];
            first.setRemainingTicks(this.preparationStageLength);
            first.init();
        }

        public void tick(PlayerEntity player) {
            if (!this.finished) {
                IReloadingStage stage = this.getCurrent();
                if (stage.isFinished()) {
                    boolean willAdvance = this.canAdvance();
                    this.stageFinishCallback.onStageFinished(player, stage, !willAdvance);
                    if (!willAdvance) {
                        this.finished = true;
                        PlayerData.get(player).ifPresent(data -> data.getHandState().freeHands());
                        return;
                    }
                    this.actualStage = this.awaitingCancelation ? this.definitions.length - 1 : ++this.actualStage;
                    stage = this.getCurrent();
                    stage.init();
                }
                stage.tick(player);
            }
        }

        public IReloadingStage getCurrent() {
            return this.definitions[this.actualStage];
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public float getPreparationProgress() {
            boolean isPrepStage;
            IReloadingStage stage = this.getCurrent();
            boolean bl = isPrepStage = stage.stageType() == ReloadingStageType.PREPARATION;
            if (isPrepStage) {
                PreparationStage preparationStage = (PreparationStage)stage;
                float stageProgress = (float)preparationStage.ticks / (float)this.preparationStageLength;
                return preparationStage.inverseProgress ? stageProgress : 1.0f - stageProgress;
            }
            return 1.0f;
        }

        private boolean canAdvance() {
            return this.actualStage < this.definitions.length - 1;
        }
    }

    public static interface IStageFinishCallback {
        public void onStageFinished(PlayerEntity var1, IReloadingStage var2, boolean var3);
    }

    public static enum ReloadingStageType {
        PREPARATION,
        LOADING;

    }

    public static class LoadingStage
    extends AbstractReloadingStage {
        private final ResourceLocation animationPath;

        public LoadingStage(ResourceLocation animationPath) {
            this.animationPath = animationPath;
        }

        @Override
        public ReloadingStageType stageType() {
            return ReloadingStageType.LOADING;
        }

        @Override
        public void init() {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::playLoadAnimation);
        }

        @Override
        public void initClient(ResourceLocation path, StageDefinitionContainer container) {
        }

        @OnlyIn(value=Dist.CLIENT)
        private void playLoadAnimation() {
            AnimationEngine engine = AnimationEngine.get();
            IAnimationPipeline pipeline = engine.pipeline();
            IAnimationLoader loader = engine.loader();
            IKeyframeProvider provider = loader.getProvider(this.animationPath);
            ReloadAnimation modifiableProgressAnimation = new ReloadAnimation(provider, this.ticks);
            pipeline.insert(ModAnimations.RELOAD_BULLET, modifiableProgressAnimation);
        }
    }

    public static class PreparationStage
    extends AbstractReloadingStage {
        private final boolean inverseProgress;

        public PreparationStage(boolean inverseProgress) {
            this.inverseProgress = inverseProgress;
        }

        @Override
        public ReloadingStageType stageType() {
            return ReloadingStageType.PREPARATION;
        }

        @Override
        public void init() {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void initClient(ResourceLocation path, StageDefinitionContainer container) {
            AnimationEngine engine = AnimationEngine.get();
            IAnimationPipeline pipeline = engine.pipeline();
            IAnimationLoader loader = engine.loader();
            IKeyframeProvider provider = loader.getProvider(path);
            StagedReloadAnimation animation = new StagedReloadAnimation(provider, container::hasFinished, container::getPreparationProgress);
            pipeline.insert(ModAnimations.RELOAD, animation);
        }
    }

    public static abstract class AbstractReloadingStage
    implements IReloadingStage {
        protected int ticks;

        @Override
        public boolean isFinished() {
            return this.ticks <= 0;
        }

        @Override
        public void tick(PlayerEntity player) {
            --this.ticks;
        }

        @Override
        public void setRemainingTicks(int remainingTicks) {
            this.ticks = remainingTicks;
        }
    }

    public static interface IReloadingStage {
        public ReloadingStageType stageType();

        public void init();

        @OnlyIn(value=Dist.CLIENT)
        public void initClient(ResourceLocation var1, StageDefinitionContainer var2);

        public void tick(PlayerEntity var1);

        public boolean isFinished();

        public void setRemainingTicks(int var1);
    }
}

